/* Adobe.BlendMode.js -- BlendMode behavior for Animal */
/*global define */

define(["lib/Zoot", "lib/tasks"],
function (Z, tasks) {
	"use strict";

	var	kBlend_PassThrough = -1,
		kBlend_InFront = 0,
		kBlend_Add = 1,
		kBlend_Screen = 2,
		kBlend_Stencil = 3,
    	kBlend_Darken = 4,
    	kBlend_Multiply = 5,
    	kBlend_ColorBurn = 6,
    	kBlend_LinearBurn = 7,
    	kBlend_DarkerColor= 8,
    	kBlend_Lighten = 9,
    	kBlend_ColorDodge = 10,
    	kBlend_LighterColor = 11,
    	kBlend_Overlay = 12,
    	kBlend_HardLight = 13,
    	kBlend_LinearLight = 14,
    	kBlend_PinLight = 15,
    	kBlend_HardMix = 16,
    	kBlend_Difference = 17,
    	kBlend_Exclusion = 18,
    	kBlend_Subtract = 19,
    	kBlend_Divide = 20,
		kBlend_SoftLight = 21,
		kBlend_VividLight = 22;

	return {
		about: "$$$/private/animal/Behavior/BlendMode/About=Blend Mode",
		description: "$$$/private/animal/Behavior/BlendMode/Desc=Set the puppet's Blend Mode",
		uiName: "$$$/private/animal/Behavior/BlendMode/UIName=Blend Mode",
		defaultArmedForRecordOn: true,
		hideInBehaviorList: true,
	
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{ id: "BlendMode", type: "enum", uiName: "$$$/private/animal/Behavior/BlendMode/Parameter/BlendMode=Blend Mode",
					items: [{ id: kBlend_PassThrough, uiName: "$$$/animal/blend/PassThrough=Pass Through" },
							{ id: "separator0"},
							{ id: kBlend_InFront, uiName: "$$$/animal/blend/Normal=Normal" },
							{ id: "separator1"},
							{ id: kBlend_Darken, uiName: "$$$/animal/blend/Darken=Darken" },
							{ id: kBlend_Multiply, uiName: "$$$/animal/blend/Multiply=Multiply" },
							{ id: kBlend_ColorBurn, uiName: "$$$/animal/blend/ColorBurn=Color Burn" },
							{ id: kBlend_LinearBurn, uiName: "$$$/animal/blend/LinearBurn=Linear Burn" },
							{ id: kBlend_DarkerColor, uiName: "$$$/animal/blend/DarkerColor=Darker Color" },
							{ id: "separator2"},
							{ id: kBlend_Lighten, uiName: "$$$/animal/blend/Lighten=Lighten" },
							{ id: kBlend_Screen, uiName: "$$$/animal/blend/Screen=Screen" },
							{ id: kBlend_ColorDodge, uiName: "$$$/animal/blend/ColorDodge=Color Dodge" },
							{ id: kBlend_Add, uiName: "$$$/animal/blend/LinearDodgeAdd=Linear Dodge (Add)" },
							{ id: kBlend_LighterColor, uiName: "$$$/animal/blend/LighterColor=Lighter Color" },
							{ id: "separator3"},
							{ id: kBlend_Overlay, uiName: "$$$/animal/blend/Overlay=Overlay" },
							{ id: kBlend_SoftLight, uiName: "$$$/animal/blend/SoftLight=Soft Light" },
							{ id: kBlend_VividLight, uiName: "$$$/animal/blend/VividLight=Vivid Light" },
							{ id: kBlend_HardLight, uiName: "$$$/animal/blend/HardLight=Hard Light" },
							{ id: kBlend_LinearLight, uiName: "$$$/animal/blend/LinearLight=Linear Light" },
							{ id: kBlend_PinLight, uiName: "$$$/animal/blend/PinLight=Pin Light" },
							//{ id: kBlend_HardMix, uiName: "$$$/animal/blend/HardMix=Hard Mix" },
							{ id: "separator4"},
							{ id: kBlend_Difference, uiName: "$$$/animal/blend/Difference=Difference" },
							{ id: kBlend_Exclusion, uiName: "$$$/animal/blend/Exclusion=Exclusion" },
							{ id: kBlend_Subtract, uiName: "$$$/animal/blend/Subtract=Subtract" },
							{ id: kBlend_Divide, uiName: "$$$/animal/blend/Divide=Divide" },
					        { id: "separator5"},
							{ id: kBlend_Stencil, uiName: "$$$/animal/blend/Stencil=Stencil" }
						   ], dephault: kBlend_PassThrough
				}
			];
		},

		onCreateBackStageBehavior: function (self) {
			return { order: 0.01, importance : 0.0 };
		},

		onCreateStageBehavior: function (self, args) {
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage		
			var blend = args.getParam("BlendMode"), blendModeName, 
				blendNameMap = [ 
									"In Front",
									"Add",
									"Screen",
									"Stencil",
									"Darken",
									"Multiply",
									"Color Burn",
									"Linear Burn",
									"Darker Color",
									"Lighten",
									"Color Dodge",
									"Lighter Color",
									"Overlay",
									"Hard Light",
									"Linear Light",
									"Pin Light",
									"Hard Mix",
									"Difference",
									"Exclusion",
									"Subtract",
									"Divide",
									"SoftLight",
									"VividLight"
							   ];
		
			if (blend !== kBlend_PassThrough) {
				blendModeName = blendNameMap[blend];
			}
			args.stageLayer.setBlendMode(blendModeName);
		}

	}; // end of object being returned
});
